#include <mega16.h>
#include <delay.h>                               
#include <stdio.h> 
#include <stdlib.h> 
#asm
   .equ __i2c_port=0x15 ;PORTC  
   .equ __sda_bit=1
   .equ __scl_bit=0
#endasm
#include <i2c.h>
#include <ds1307.h>
#define  b_set     PINB.0
#define  b_dec     PINB.1      
#define  b_inc     PINB.2    
#define  OK     1
#define  Error  8 

unsigned char hour=0,minute=0,second=0;
unsigned char part1=0,part2=0;
flash unsigned char segdata[]={0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F};

//____________________________________________________________________
void hex_to_seg(unsigned char a)
   {
   part2=segdata[a%10];
   part1=segdata[a/10];
   }
//____________________________________________________________________  
void inc_minute()
{
unsigned char myminute;
rtc_get_time(&hour,&minute,&second);
myminute=minute+1;
if(myminute>59)
myminute=0;
rtc_set_time(hour,myminute,second);
}
//_________________________________________________________
void inc_hour()
{
unsigned char myhour;
rtc_get_time(&hour,&minute,&second);
myhour=hour+1;
if(myhour>23)
myhour=0;
rtc_set_time(myhour,minute,second);
}
//____________________________________________________________
void main(){
 
PORTA=0x00;
DDRA=0XFF;
PORTD=0XFF;
DDRD=0XFF; 
PORTC=0X00;
DDRC=0X00;
PORTB=0X00;
DDRB=0X08;
i2c_init();
rtc_init(0,0,0);
rtc_set_time(12,0,0);
     
while (1){ 

rtc_get_time(&hour,&minute,&second);

hex_to_seg(minute);
PORTD=0b11110111;
PORTA=part2;
delay_ms(2);

PORTD=0b11111011;
PORTA=part1;
delay_ms(2);
 
hex_to_seg(hour);
PORTD=0b11111101;
PORTA=part2;
delay_ms(2);

PORTD=0b11111110;
PORTA=part1;
delay_ms(2);
 
if(PINB.1==0){
  delay_ms(100);
  inc_hour();
  }
if(PINB.2==0){
  delay_ms(100);
  inc_minute();
  }    
 }
}  